/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.tagging;

public class LemmaInfos {
    String source= new String();
    String lex   = new String();
    String lemma = new String();
//    int position;
//    String lex   = new String();
    
    // create a LemmaInfos from a TreeTagger line
    public LemmaInfos(String ligne){
        String[] elems = ligne.split("\t");
        if (elems.length==3){
            source = elems[0].toLowerCase();
            lex = elems[1];
            if (elems[2].contains("|")){
                String[] ambiguities = elems[2].split("\\|");
                lemma = ambiguities[0].toLowerCase();
            }else if (elems[2].matches("@card@") ){
                lemma = elems[0].toLowerCase();
            }else{
                lemma = elems[2].toLowerCase();
            }
        }
    }
    
    // return the lemma
    public String get_lemma(){
        return lemma;
    } 

    public String get_lex(){
        return lex;
    } 
 
    public String get_source(){
        return source;
    }     

/*    public int get_position(){
        return position;
    }*/

    @Override
    public String toString(){
        String res = source+"\t"+lex+"\t"+lemma+"\n";
        return res;
    }

    @Override
    public boolean equals(Object o){
        if(!(o instanceof LemmaInfos)) return false;
        LemmaInfos l = (LemmaInfos)o;
        return l.get_lemma().equals(get_lemma()) && l.get_lex().equals(get_lex());
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.lex != null ? this.lex.hashCode() : 0);
        hash = 29 * hash + (this.lemma != null ? this.lemma.hashCode() : 0);
        return hash;
    }
    
}
